<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */
?>
					<script>
						$(function() {
							$("#tabs").tabs();
							$('[id^=details-modal]').dialog({ autoOpen: false });
							$('[id^=details-link-active]').click(function(e){
								e.preventDefault();
								var id = $(e.target).attr('id').replace('details-link-active','');
								$('[id^=details-modal-active]').dialog({
									modal:true,
									width:300,
									height:250
								});
								$('[id=details-modal-active'+id+']').dialog('open');
							});

							$('[id^=details-link-inactive]').click(function(e){
								e.preventDefault();
								var id = $(e.target).attr('id').replace('details-link-inactive','');
								$('[id^=details-modal-inactive]').dialog({
									modal:true,
									width:300,
									height:250
								});
								$('[id=details-modal-inactive'+id+']').dialog('open');
							});
							
						});
					</script>
					<div class="column">
						<?PHP if(isset($message)) { echo '<div id="message_info" class="message_info">'.$message.'</div>'; } ?>
						<?PHP if(isset($success_message)) { echo '<div id="message_success" class="message_success">'.$success_message.'</div>'; } ?>
						<?PHP if(isset($error_message)) { echo '<div id="message_error" class="message_error">'.$error_message.'</div>'; } ?>
						<div id="tabs" class="column">	
							<ul>
								<li><a id="accounts_link" href="#accounts" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Accounts</a></li>
								<li><a id="deactivated_link" href="#deactivated" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Disabled Accounts</a></li>
								<?PHP if($create_account_show) { ?><li><a href="#create" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Create Account</a></li><?PHP } ?>
							</ul>
							
							<div id="accounts">
								<p>This table lists the active accounts on the system.</p>
									<br/>
									<table id="active_account_table" class="display">
									<thead>
										<tr class="gridheader">
											<th scope="col">User Name</th>
											<th scope="col">ID</th>											
											<th scope="col">Details</th>
											<th scope="col">Access</th>
											<th class="displaylast">Actions</th>
										</tr>
									</thead>
									<tbody>
										<?PHP foreach($users as $user) { ?>
											<tr>
												<td class="center"><a href="/administration/manage/accounts/edit/<?PHP echo $user->user_id; ?>"><?PHP echo $user->username; ?></a></td>
												<td class="center"><?PHP echo $user->user_org_id; ?></td>
												<td class="center">
													<a href="#" id="details-link-active<?PHP echo $user->user_id; ?>">View Details</a>
													<div id="details-modal-active<?PHP echo $user->user_id; ?>" title="Account Details for <?PHP echo $user->username;?>">
														<table>
														<?PHP 
															echo '<tr><td>Name</td><td>'.$user->cn . '</td></tr>';
															if($user->title) { echo '<tr><td>Title</td><td>'.$user->title . '</td></tr>'; }
															if($user->departmentnumber) { echo '<tr><td>Department</td><td>'.$user->departmentnumber . '</td></tr>'; }
															if($user->o) { echo '<tr><td>Organization</td><td>'.$user->o . '</td></tr>'; }
															if($user->physicaldeliveryofficename) { echo '<tr><td>Location</td><td>'.$user->physicaldeliveryofficename . '</td></tr>'; }
															if($user->telephonenumber) { echo '<tr><td>Telephone</td><td>'.$user->telephonenumber . '</td></tr>'; }
															if($user->mobile) { echo '<tr><td>Mobile</td><td>'.$user->mobile . '</td></tr>'; }
															if($user->user_ext_mail) { echo '<tr><td>Email</td><td><a href="mailto:'.$user->user_ext_mail.'">'.$user->user_ext_mail.'</a></td></tr>'; }
														?>
														</table>
													</div>
												</td>
												<td><?PHP foreach($user->groups as $group) { echo $group . '<br/>'; } ?></td>
												<td class="center">
													<a href="/administration/manage/accounts/edit/<?PHP echo $user->user_id; ?>" title="Edit Account: <?PHP echo $user->username; ?>"><img src="/images/icons/user_edit.png" alt="Edit Account: <?PHP echo $user->username; ?>" /></a>
													<?PHP if($account_permission){ ?>
													<a href="/administration/manage/accounts/edit/access/<?PHP echo $user->user_id; ?>" title="Edit Access: <?PHP echo $user->username; ?>"><img src="/images/icons/group_edit.png" alt="Edit Access: <?PHP echo $user->username; ?>" /></a>
													<?PHP }if($disable_permission){ ?>
														<a onclick="if(confirm('Are you sure you want to disable <?PHP echo $user->username ?>?')) {$('#disable<?PHP echo $user->user_id; ?>').submit(); return false; }" href="#" title="Disable Account: <?PHP echo $user->username; ?>"><img src="/images/icons/delete.png" alt="Disable Account: <?PHP echo $user->username; ?>" /></a>
													<?PHP
														}
														echo form_open('/administration/manage/accounts/disable',array('id'=>'disable'.$user->user_id));
														echo form_hidden('user_id', $user->user_id);
														echo form_close();
													?>
												</td>
											</tr>
										<?PHP } ?>
									</tbody>
									</table>
							</div>
							<div id="deactivated">
								<p>This table lists the disabled accounts on the system.</p>
									<br/>
									<table id="disabled_account_table" class="display">
									<thead>
										<tr class="gridheader">
											<th scope="col">User Name</th>
											<th scope="col">ID</th>											
											<th scope="col">Details</th>
											<th scope="col">Access</th>
											<th class="displaylast">Actions</th>
										</tr>
									</thead>
									<tbody>
										<?PHP foreach($disabled_users as $user) { ?>
											<tr>
												<td class="center"><a href="/administration/manage/accounts/edit/<?PHP echo $user->user_id; ?>"><?PHP echo $user->username; ?></a></td>
												<td class="center"><?PHP echo $user->user_org_id; ?></td>
												<td class="center">
													<a href="#" id="details-link-inactive<?PHP echo $user->user_id; ?>">View Details</a>
													<div id="details-modal-inactive<?PHP echo $user->user_id; ?>" title="Account Details for <?PHP echo $user->username;?>">
														<table>
														<?PHP 
															echo '<tr><td>Name</td><td>'.$user->cn . '</td></tr>';
															if($user->title) { echo '<tr><td>Title</td><td>'.$user->title . '</td></tr>'; }
															if($user->departmentnumber) { echo '<tr><td>Department</td><td>'.$user->departmentnumber . '</td></tr>'; }
															if($user->o) { echo '<tr><td>Organization</td><td>'.$user->o . '</td></tr>'; }
															if($user->physicaldeliveryofficename) { echo '<tr><td>Location</td><td>'.$user->physicaldeliveryofficename . '</td></tr>'; }
															if($user->telephonenumber) { echo '<tr><td>Telephone</td><td>'.$user->telephonenumber . '</td></tr>'; }
															if($user->mobile) { echo '<tr><td>Mobile</td><td>'.$user->mobile . '</td></tr>'; }
															if($user->user_ext_mail) { echo '<td>Email</td><td><a href="mailto:'.$user->user_ext_mail.'">'.$user->user_ext_mail.'</a></td></tr>'; }
														?>
														</table>
													</div>
												</td>
												<td><?PHP foreach($user->groups as $group) { echo $group . '<br/>'; } ?></td>
												<td class="center">
													<a href="/administration/manage/accounts/edit/<?PHP echo $user->user_id; ?>" title="Edit Account: <?PHP echo $user->username; ?>"><img src="/images/icons/user_edit.png" alt="Edit Account: <?PHP echo $user->username; ?>" /></a>
													<?PHP if($account_permission){ ?>
													<a href="/administration/manage/accounts/edit/access/<?PHP echo $user->user_id; ?>" title="Edit Access: <?PHP echo $user->username; ?>"><img src="/images/icons/group_edit.png" alt="Edit Access: <?PHP echo $user->username; ?>" /></a>
													<?PHP }if($enable_permission){ ?>
													<a onclick="if(confirm('Are you sure you want to enable <?PHP echo $user->username ?>?')) { $('#enable<?PHP echo $user->user_id; ?>').submit(); return false; }" href="#" title="Enable Account: <?PHP echo $user->username; ?>"><img src="/images/icons/add.png" alt="Enable Account: <?PHP echo $user->username; ?>" /></a>
													<?PHP 
														}
														echo form_open('/administration/manage/accounts/enable',array('id'=>'enable'.$user->user_id));
														echo form_hidden('user_id',$user->user_id);
														echo form_close();
													?>
												</td>
											</tr>
										<?PHP } ?>
									</tbody>
									</table>
									<br/>
							</div>
							<?PHP if($create_account_show) { ?>
								<div id ="create" class="column">		
									<p>This form allows an administrator to manually create a new user account.</p>
									<?PHP echo form_open('/administration/create_account','createAccountForm'); ?>
										<div class="form" style="width:100%;">
											<label for="user_name"><span class="red-text">*</span>Username:</label> <input type="text" name="user_name" id="user_name" <?PHP if(isset($user_name)) { echo 'value="'.$user_name.'"'; }?>/>
											<label for="user_org_id"><span class="red-text">*</span>ID:</label> <input type="text" name="user_org_id" id="user_org_id" <?PHP if(isset($user_org_id)) { echo 'value="'.$user_org_id.'"'; }?>/>
											<label for="first_name"><span class="red-text">*</span>First Name:</label> <input type="text" name="first_name" id="first_name" value="<?php if(isset($first_name)){echo $first_name;}?>"/>
											<label for="middle_name">Middle Name:</label> <input type="text" name="middle_name" id="middle_name" <?PHP if(isset($middle_name)) { echo 'value="'.$middle_name.'"'; }?>/>
											<label for="last_name"><span class="red-text">*</span>Last Name:</label> <input type="text" name="last_name" id="last_name" <?PHP if(isset($last_name)) { echo 'value="'.$last_name.'"'; }?>/>
											<label for="ext_mail"><span class="red-text">*</span>Email Address:</label> <input type="text" name="ext_mail" id="ext_mail" <?PHP if(isset($ext_mail)) { echo 'value="'.$ext_mail.'"'; }?>/>
											<label for="account_title">Title:</label> <input type="text" name="account_title" id="account_title" <?PHP if(isset($account_title)) { echo 'value="'.$account_title.'"'; }?>/>
											<label for="department">Department:</label> <input type="text" name="department" id="department" <?PHP if(isset($department)) { echo 'value="'.$department.'"'; }?>/>
											<label style="display:none;" for="organization">Organization:</label> <input style="display:none;" type="text" name="organization" id="organization" <?PHP if(isset($organization)) { echo 'value="'.$organization.'"'; }?>/>
											<label for="telephone">Telephone:</label> <input type="text" name="telephone" id="telephone" <?PHP if(isset($telephone)) { echo 'value="'.$telephone.'"'; }?>/>
											<label for="mobile">Mobile Phone:</label> <input type="text" name="mobile" id="mobile" <?PHP if(isset($mobile)) { echo 'value="'.$mobile.'"'; }?>/>
											<label style="display:none;" for="location">Location:</label> <input style="display:none;" type="text" name="location" id="location" <?PHP if(isset($location)) { echo 'value="'.$location.'"'; }?>/>
											<label for="facility"><span class="red-text">*</span>Facility:</label>
											<select id="facility_select" name="facility_select" data-placeholder="Choose a Facility" tabindex="">
				           	 					<option value=""></option>
				           	 					<option value="">&nbsp;</option>
				           						<?php foreach($facilities as $fac) {
				           							$option = '<option value=' . $fac->id;
				           							if(isset($facility_select) & $fac->id == $facility_select) {
														$option = $option . ' selected';
													}
													$option = $option . '>' . $fac->name . '</option>';
				           							echo $option;
				           						}?>
				            				</select>
											<p class="red-text">
												* = Required Field
											</p>
										</div>
										<div class="text-right" style="width:100%;"><input class="blue-button" type="submit" value="Submit"/></div> 
									<?PHP echo form_close(); ?>
								</div>								
							<?PHP } ?>
						</div>
					</div>
<script type='text/javascript'>
	var beforeInitializeActiveUserTable = true;
	var beforeInitializeInactiveUserTable = true;
	
	function openDetailDialog(id){
		$('[id=details-modal-active'+id+']').dialog({
			modal:true,
			width:300,
			height:250
		});
		$('[id=details-modal-active'+id+']').dialog('open');

		$('[id=details-modal-inactive'+id+']').dialog({
			modal:true,
			width:300,
			height:250
		});
		$('[id=details-modal-inactive'+id+']').dialog('open');
	}
	
	$('#facility_select').chosen();

	$(document).ready(function() {

	    $('#active_account_table').dataTable( {
	    	"preDrawCallback": function(settings, json) {
		    	if(!beforeInitializeActiveUserTable) {
		    		$('[id^=details-modal-active]').dialog({ autoOpen: false });
		    		$('[id^=details-modal-active]').dialog('destroy').remove();
		    	}
	    	},
	    	"drawCallback": function(settings, json) {
	    		beforeInitializeActiveUserTable = false;
	    	},
			"bSort" : false,
	        "bProcessing": true,
	        "bServerSide": true,
			"iDeferLoading":  <?PHP echo $users_total; ?>,
          	"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3,4]},
        		             { 'bSearchable': false, 'aTargets': [0,1,2,3,4]},
        		             { "sClass": "center", 'aTargets': [0,1,2,4]}],
	        "sAjaxSource": '/administration/admin_account_search/?active=true&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
	        "oLanguage": {
	        	"sEmptyTable": "No accounts were found",
	        	"sZeroRecords": "No accounts were found",
				"sInfo": "_TOTAL_ results",
				"sLengthMenu": "Records per page _MENU_",
	        	}, 
	 	    } );
	} );

	$(document).ready(function() {
	    $('#disabled_account_table').dataTable( {
	    	"preDrawCallback": function(settings, json) {
		    	if(!beforeInitializeInactiveUserTable) {
		    		$('[id^=details-modal-inactive]').dialog({ autoOpen: false });
		    		$('[id^=details-modal-inactive]').dialog('destroy').remove();
		    	}
	    	},
	    	"drawCallback": function(settings, json) {
	    		beforeInitializeInactiveUserTable = false;
	    	},
			"bSort" : false,
	        "bProcessing": true,
	        "bServerSide": true,
			"iDeferLoading": <?PHP echo $disabled_users_total;?>,
          	"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3,4]},
        		             { 'bSearchable': false, 'aTargets': [0,1,2,3,4]},
        		             { "sClass": "center", 'aTargets': [0,1,2,4]}],
	        "sAjaxSource": '/administration/admin_account_search/?active=false&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
	        "oLanguage": {
				"sEmptyTable": "No accounts were found",
	        	"sZeroRecords": "No accounts were found",
				"sInfo": "_TOTAL_ results",
				"sLengthMenu": "Records per page _MENU_",
	        },    
		} );
	} );
</script>